/* Based on http://www.geeks3d.com/20110405/fxaa-fast-approximate-anti-aliasing-demo-glsl-opengl-test-radeon-geforce/3/ */

#version 330

uniform mat4 worldviewproj;
uniform vec4 invRtSize;

in vec4 vertex;
in vec2 uv0;

out vec4 posPos;

void main()
{
	const float FXAA_SUBPIX_SHIFT = 1.0/4.0;
	gl_Position = worldviewproj*vertex;
	posPos.xy = uv0.xy;
	posPos.zw = uv0.xy - (invRtSize.xy * (0.5 + FXAA_SUBPIX_SHIFT));
}